#include <bits/stdc++.h>
using namespace std;

const int N = 200005;

vector<int> graph[N];
int parent[N];
int b[N];
pair<int, int> query[N];
int n, q;
int distinct[2 * N];

void getParents(int v, int p){
    parent[v] = p;
    for(auto u : graph[v]){
        if(u != p){
            getParents(u, v);
        }
    }
}

void buildDistinct(int v){
    distinct[v] = 1;
    for(auto u : graph[v]){
        if(parent[v] != u){
            buildDistinct(u);
            distinct[v] += distinct[u] - (b[u] == b[v]);
        }
    }
}

void colorSubtreeBrute(int v, int nb){
    b[v] = nb;
    for(auto u : graph[v]){
        if(u != parent[v]){
            colorSubtreeBrute(u, nb);
        }
    }
}

void solve1(){ //n,q <= 10^3
    for(int i = 0; i < q; ++i){
        colorSubtreeBrute(query[i].first, query[i].second);
        buildDistinct(0);
        cout << distinct[0] << "\n";
    }
}

bool c1visited[N];

void c1colorSubtree(int v, int nb){
    if(c1visited[v])
        return;
    c1visited[v] = true;
    b[v] = nb;
    distinct[v] = 1;
    for(auto u : graph[v]){
        if(u != parent[v]){
            c1colorSubtree(u, nb);
        }
    }
}

void getRealDistinct(int v){
    if(c1visited[v])
        return;
    distinct[v] = 1;
    for(auto u : graph[v]){
        if(u != parent[v]){
            getRealDistinct(u);
            distinct[v] += distinct[u] - (b[u] == b[v]);
        }
    }
}

void solve2(){ //c=1
    buildDistinct(0);
    int total = distinct[0];
    for(int i = 0; i < q; ++i){
        int u = query[i].first;
        int c = query[i].second;
        getRealDistinct(u);
        int oldDistinct = distinct[u];
        int oldColor = b[u];
        c1colorSubtree(u, c);
        total += (distinct[u] - oldDistinct) - (parent[u] != -1 && b[parent[u]] == b[u] && oldColor != b[u]) + (parent[u] != -1 && oldColor == parent[u] && oldColor != b[u]);
        cout << total << "\n";
    }
}

struct StElement{
    int lel, rel, val;
};

StElement lnst[4 * N];
int lnlazy[4 * N];

void lnbuild(int id, int l, int r){
    if(l == r){
        lnst[id].lel = lnst[id].rel = b[l];
        lnst[id].val = 1;
        return;
    }

    int mid = (l + r) / 2;
    lnbuild(id * 2 + 1, l, mid);
    lnbuild(id * 2 + 2, mid + 1, r);

    lnst[id].val = lnst[id * 2 + 1].val + lnst[id * 2 + 2].val - (lnst[id * 2 + 1].rel == lnst[id * 2 + 2].lel);
    lnst[id].lel = lnst[id * 2 + 1].lel;
    lnst[id].rel = lnst[id * 2 + 2].rel;
}

void lnupdNode(int v, int id, int l, int r){
    lnlazy[id] = v;
    lnst[id].val = 1;
    lnst[id].lel = lnst[id].rel = v;
}

void lnshift(int id, int l, int r){
    int mid = (l + r) / 2;
    if(lnlazy[id] != 0){
        lnupdNode(lnlazy[id], id * 2 + 1, l, mid);
        lnupdNode(lnlazy[id], id * 2 + 2, mid + 1, r);
        lnlazy[id] = 0;
    }
}

void lnupdate(int x, int y, int v, int id, int l, int r){
    if(x > r || y < l)
        return;

    if(x <= l && r <= y){
        lnupdNode(v, id, l, r);
        return;
    }

    lnshift(id, l, r);

    int mid = (l + r) / 2;
    lnupdate(x, y, v, id * 2 + 1, l, mid);
    lnupdate(x, y, v, id * 2 + 2, mid + 1, r);

    lnst[id].val = lnst[id * 2 + 1].val + lnst[id * 2 + 2].val - (lnst[id * 2 + 1].rel == lnst[id * 2 + 2].lel);
    lnst[id].lel = lnst[id * 2 + 1].lel;
    lnst[id].rel = lnst[id * 2 + 2].rel;
}

void solve3(){ //grana izmedju i,i-1
    lnbuild(0, 0, n - 1);
    for(int i = 0; i < q; ++i){
        int u, c;
        u = query[i].first;
        c = query[i].second;
        lnupdate(u, n - 1, c, 0, 0, n - 1);
        StElement res = lnst[0];
        cout << res.val << "\n";
    }
}

int balst[4 * N];
int ballazy[4 * N];

void balbuild(int id){
    balst[id] = 1;

    if(id * 2 + 1 < n){
        balbuild(id * 2 + 1);
        balst[id] += balst[id * 2 + 1] - (b[id] == b[id * 2 + 1]);
    }
    if(id * 2 + 2 < n){
        balbuild(id * 2 + 2);
        balst[id] += balst[id * 2 + 2]- (b[id] == b[id * 2 + 2]);
    }
}

void balupdNode(int v, int c){
    ballazy[v] = c;
    balst[v] = 1;
    b[v] = c;
}

void balshift(int id){
    if(ballazy[id] != 0){
        if(id * 2 + 1 < n)
            balupdNode(ballazy[id], id * 2 + 1);
        if(id * 2 + 2 < n)
            balupdNode(ballazy[id], id * 2 + 2);
        ballazy[id] = 0;
    }
}

void balupdate(int v, int c){
    vector<int> path;
    int u = parent[v];
    while(u != -1){
        path.push_back(u);
        u = parent[u];
    }

    for(int i = (int)path.size() - 1; i >= 0; --i){
        balshift(path[i]); //fix old lazys
    }
    balupdNode(v, c); //make new lazy
    for(int i = 0; i < (int)path.size(); ++i){
        int id = path[i];
        balst[id] = 1;
        if(id * 2 + 1 < n) //update parents with my new value
            balst[id] += balst[id * 2 + 1] - (b[id] == b[id * 2 + 1]);
        if(id * 2 + 2 < n)
            balst[id] += balst[id * 2 + 2]- (b[id] == b[id * 2 + 2]);
    }
}

void solve4(){ //balanced tree
    balbuild(0);
    for(int i = 0; i < q; ++i){
        int u, c;
        u = query[i].first;
        c = query[i].second;
        balupdate(u, c);
        int res = balst[0];
        cout << res << "\n";
    }
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    cin >> n >> q;
    bool isLine = true;
    for(int i = 0; i < n - 1; ++i){
        int u, v;
        cin >> u >> v;
        --u;--v;
        graph[u].push_back(v);
        graph[v].push_back(u);
        if(min(u, v) + 1 != max(u, v))
            isLine = false;
    }
    for(int i = 0; i < n; ++i){
        cin >> b[i];
    }
    bool sameC = true;
    for(int i = 0; i < q; ++i){
        cin >> query[i].first >> query[i].second;
        query[i].first--;
        if(query[i].second != 1)
            sameC = false;
    }
    getParents(0, -1);

    if(n <= 1000 && q <= 1000){
        solve1();
    }else if(sameC){
        solve2();
    }else if(isLine){
        solve3();
    }else{
        solve4();
    }

    return 0;
}

/*
line:
7 3
1 2
2 3
3 4
4 5
5 6
6 7
2 3 3 2 3 2 1
4 2
6 3
1 1
--
3
4
1

bal:
6 7
1 2
1 3
2 4
2 5
3 6
3 2 3 1 1 2
4 2
5 2
5 3
2 2
2 3
3 2
1 3
---
4
3
4
3
2
2
1

c1:
13 5
1 2
1 3
3 4
3 10
4 5
4 6
6 7
7 9
7 8
10 11
10 12
10 13
1 2 2 1 1 2 2 1 1 2 2 2 2
6 1
10 1
3 1
7 1
1 1
---
4
5
2
2
1
*/